IF OBJECT_ID('EST_ORC_VENDA_PERDIDA') IS NULL
BEGIN
CREATE TABLE [dbo].[EST_ORC_VENDA_PERDIDA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_ORC] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_ORC_VENDA_PERDIDA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_ORC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_ORC_VENDA_PERDIDA] ADD  CONSTRAINT [DF_EST_ORC_VENDA_PERDIDA_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_ORC_VENDA_PERDIDA]  WITH CHECK ADD  CONSTRAINT [FK_EST_ORC_VENDA_PERDIDA_EST_ORC] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_ORC])
REFERENCES [dbo].[EST_ORC] ([CD_EMP], [CD_FILIAL], [CD_ORC])

ALTER TABLE [dbo].[EST_ORC_VENDA_PERDIDA] CHECK CONSTRAINT [FK_EST_ORC_VENDA_PERDIDA_EST_ORC]
end
